/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.io.File;

import com.inet.report.Area;
import com.inet.report.Element;
import com.inet.report.Engine;
import com.inet.report.FieldElement;
import com.inet.report.RDC;
import com.inet.report.Section;
import com.inet.report.ValueProperties;

/**
 * This sample shows how to change the year type for all fields in Page Header section of the report.
 */
public class ModifyDateFields {

    /**
     * This main method starts a new Engine, sets the report file, goes through the Page Header section and change the
     * year type of date fields included in the Page Header section.
     * @param argv Arguments not used in this sample
     */
    public static void main( String[] argv ) {
        try {
            // Create a new Engine
            Engine engine = new Engine( Engine.NO_EXPORT );
            // Set the name of the report file, that contain
            engine.setReportFile( "samples/rdc/ModifyDateFields.rpt" );

            // Set a new year type for all fields in Page Header section
            Area phArea = engine.getArea( "PH" );
            Section phSec = phArea.getSection( 0 );

            // All elements in the Page Header section
            Element[] elements = phSec.getElements();
            for( int i = 0; i < elements.length; i++ ) {
                Element element = elements[i];
                if( element instanceof FieldElement ) {
                    FieldElement fElem = (FieldElement)elements[i];
                    fElem.setYearType( ValueProperties.LONG_YEAR ); // set year type "yyyy" for all field elements in page header section
                }
            }

            // If necessary you can save the modified report in a new file.
            RDC.saveEngine( new File( System.getProperty( "user.dir" ) + "/samples/rdc/ModifiedDateFields.rpt" ), engine );
        } catch( Throwable e ) {
            e.printStackTrace();
            System.exit( 0 );
        }
    }
}
